﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using System.Diagnostics;

namespace ZabezpieczKluczem
{
   class Program
   {

      /// <summary>
      /// Prosta funkcja wyszukująca wystąpienia tablicy bajtów wewnątrz innej tablicy. Dla wiekszych projektów można użyć szybszego algorytmu Boyer-Moore-Horspool
      /// </summary>
      /// <param name="aBufor">Tablica bajtów, w której szukamy</param>
      /// <param name="aSzukane">Szukana tablica bajtów</param>
      /// <returns></returns>
      static private int Szukaj(byte[] aBufor, byte[] aSzukane)
      {
         int indeks = -1;
         for (int i = 0; i < aBufor.Length - aSzukane.Length && indeks == -1 ; i++)
         {          
            int j = 0;
            while (j < aSzukane.Length && aBufor[i + j] == aSzukane[j]) j++;
            if (j == aSzukane.Length)
               indeks = i;
         }
         return indeks;
      }

      /// <summary>
      /// Główna funkcja programu podmieniająca wzorzec
      /// </summary>
      static void ZmodyfikujPlik(string aPlikZabezpieczany, string aPlikZKluczem)
      {
         // odczyt pliku zabezpieczanego
         System.IO.FileInfo fi = new System.IO.FileInfo(aPlikZabezpieczany);
         long rozmiar = fi.Length;
         byte[] zawartośćZabezpieczana = new byte[rozmiar];
         FileStream fs = File.OpenRead(aPlikZabezpieczany);
         BinaryReader reader = new BinaryReader(fs);
         zawartośćZabezpieczana = reader.ReadBytes((int)rozmiar);
         reader.Close();
         fs.Close();

         // odczyt pliku z kluczem
         fi = new System.IO.FileInfo(aPlikZKluczem);
         rozmiar = fi.Length;
         byte[] zawartośćKlucza = new byte[rozmiar];
         Debug.Assert(rozmiar > 8, "Długość klucza musi wynosić conajmniej 8 bajtów");

         fs = File.OpenRead(aPlikZKluczem);
         reader = new BinaryReader(fs);
         zawartośćKlucza = reader.ReadBytes((int)rozmiar);
         reader.Close();
         fs.Close();

         // modyfikacja zawartości
         // szukamy wystąpienia ciągu instrukcji odczytanych jako kod metody, zastąpimy je zerami, można zamiast tego użyć instrukcji NOP lub innej
         int znalezionyIndeks = Szukaj(zawartośćZabezpieczana, zawartośćKlucza);
         while (znalezionyIndeks != -1)
         {
            for (int i = znalezionyIndeks; i < znalezionyIndeks + zawartośćKlucza.Length; i++)
               zawartośćZabezpieczana[i] = 0;
            znalezionyIndeks = Szukaj(zawartośćZabezpieczana, zawartośćKlucza);
         }

         // zapis pliku
         FileStream fsw = File.OpenWrite(aPlikZabezpieczany);
         BinaryWriter writer = new BinaryWriter(fsw);
         writer.Write(zawartośćZabezpieczana);
         writer.Close();
         fsw.Close();

         Console.WriteLine(aPlikZabezpieczany + " został zmodyfikowany.");
      }

      static void Main(string[] args)
      {
         if (args.Length < 2)
         {
            Console.WriteLine("Prawidłowe wywołanie: CreateProgramKey.exe input_file_path key_file_path.");
            Console.WriteLine("  input_file_path - ścieżka do zabezpieczanego pliku.");
            Console.WriteLine("  key_file_path - ścieżka do wyjściowego pliku z kluczem programowym.");
         }
         else if (!File.Exists(args[0]))
            Console.WriteLine("Podany plik nie istnieje.");
         else ZmodyfikujPlik(args[0], args[1]);
      }
   }
}
